<?php $__env->startSection('title', 'Admin: Banks Accounts Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý tài khoản ngân hàng</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Ảnh / Icon</th>
              <th>Tên ngân hàng</th>
              <th>Chủ tài khoản</th>
              <th>Số tài khoản</th>
              <th>Chi nhánh</th>
              <th>Trạng thái</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>" class="badge bg-primary-gradient me-1"><i class="fa fa-edit"></i> sửa</a>
                  <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="badge bg-danger-gradient me-1"><i class="fa fa-trash"></i> xoá</a>
                </td>
                <td>
                  <img src="<?php echo e($item->image); ?>" width="30" alt="">
                </td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->owner); ?></td>
                <td><?php echo e($item->number); ?></td>
                <td><?php echo e($item->branch); ?></td>
                <td><?php echo e($item->status === true ? 'Đang hiện' : 'Đang ẩn'); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <button class="btn btn-primary-gradient" data-bs-toggle="modal" data-bs-target="#modal-create">Thêm tài khoản mới</button>
    </div>
  </div>

  <div class="modal fade" id="modal-create" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Thêm thông tin mới</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('admin.banks.store')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
              <label for="image" class="form-label">Ảnh / Icon</label>
              <input class="form-control" type="file" id="image" name="image" required>
            </div>
            <div class="mb-3">
              <label for="name" class="form-label">Tên ngân hàng</label>
              <input class="form-control" type="text" id="name" name="name" required>
            </div>
            <div class="mb-3">
              <label for="number" class="form-label">Số tài khoản</label>
              <input class="form-control" type="text" id="number" name="number" required>
            </div>
            <div class="mb-3">
              <label for="owner" class="form-label">Chủ tài khoản</label>
              <input class="form-control" type="text" id="owner" name="owner" required>
            </div>
            
            <div class="mb-3">
              <label for="status" class="form-label">Trạng thái</label>
              <select class="form-control" id="status" name="status">
                <option value="1">Hoạt động</option>
                <option value="0">Không hoạt động</option>
              </select>
            </div>
            <div class="mb-3">
              <button class="btn btn-danger-gradient w-100" type="submit">Thêm mới</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="modal-edit-<?php echo e($value->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Cập nhật thông tin #<?php echo e($value->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="<?php echo e(route('admin.banks.update')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
              <div class="mb-3">
                <label for="image" class="form-label">Ảnh / Icon</label>
                <input class="form-control" type="file" id="image" name="image">
              </div>
              <div class="mb-3">
                <label for="name" class="form-label">Tên ngân hàng</label>
                <input class="form-control" type="text" id="name" name="name" value="<?php echo e($value->name); ?>" required>
              </div>
              <div class="mb-3">
                <label for="number" class="form-label">Số tài khoản</label>
                <input class="form-control" type="text" id="number" name="number" value="<?php echo e($value->number); ?>" required>
              </div>
              <div class="mb-3">
                <label for="owner" class="form-label">Chủ tài khoản</label>
                <input class="form-control" type="text" id="owner" name="owner" value="<?php echo e($value->owner); ?>" required>
              </div>
              
              <div class="mb-3">
                <label for="status" class="form-label">Trạng thái</label>
                <select class="form-control" id="status" name="status">
                  <option value="1" <?php if($value->status === true): ?> selected <?php endif; ?>>Hoạt động</option>
                  <option value="0" <?php if($value->status === false): ?> selected <?php endif; ?>>Không hoạt động</option>
                </select>
              </div>
              <div class="mb-3">
                <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.banks.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/banks/index.blade.php ENDPATH**/ ?>