<?php $__env->startSection('title', 'Admin: Inventory Variables Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý phần thưởng (unit)</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap datatable">
          <thead>
            <tr>
              <th>#</th>
              <th data-orderable="false">Thao tác</th>
              <th>Ghi chú</th>
              <th>Đơn vị</th>
              <th data-orderable="false">Hình ảnh</th>
              <th>Sản lượng</th>
              <th>Min / Max</th>
              <th>Trạng thái</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $vars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <a href="javscript:void(0)" class="badge bg-primary-gradient text-white me-1" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">Sửa</a>
                  <a href="javscript:void(0)" class="badge bg-danger-gradient text-white me-1r" onclick="deleteRow(<?php echo e($item->id); ?>)">Xóa</a>
                </td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->unit); ?></td>
                <td class="text-center">
                  <img src="<?php echo e($item->image); ?>" alt="<?php echo e($item->name); ?>" class="img-fluid" style="width: 30px">
                </td>
                <td>
                  <?php echo e(number_format($item->inventories->sum('value'))); ?> <small class="text-muted"><?php echo e($item->unit); ?></small>
                </td>
                <td>
                  <?php echo e($item->min_withdraw); ?> / <?php echo e($item->max_withdraw); ?>

                </td>
                <td>
                  <?php if($item->is_active): ?>
                    <span class="badge bg-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Không hoạt động</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
              <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLabel">Cập nhật thông tin
                        #<?php echo e($item->id); ?></h5>
                      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <form action="<?php echo e(route('admin.inventories.vars.update', ['id' => $item->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                          <label for="image" class="form-label">Ảnh / Icon</label>
                          <input class="form-control" type="file" id="image" name="image">
                        </div>
                        <div class="mb-3">
                          <label for="name" class="form-label">Ghi chú</label>
                          <input class="form-control" type="text" id="name" name="name" value="<?php echo e($item->name); ?>">
                        </div>
                        <div class="mb-3">
                          <label for="unit" class="form-label">Đơn vị</label>
                          <input class="form-control" type="text" id="unit" name="unit" value="<?php echo e($item->unit); ?>">
                        </div>
                        <div class="mb-3 row">
                          <div class="col-md-6">
                            <label for="min_withdraw" class="form-label">Rút ít nhất</label>
                            <input class="form-control" type="number" id="min_withdraw" name="min_withdraw" value="<?php echo e($item->min_withdraw); ?>" required>
                          </div>
                          <div class="col-md-6">
                            <label for="max_withdraw" class="form-label">Rút nhiều nhất</label>
                            <input class="form-control" type="number" id="max_withdraw" name="max_withdraw" value="<?php echo e($item->max_withdraw); ?>" required>
                          </div>
                        </div>
                        <div class="mb-3">
                          <?php
                            $inputs = '';
                            if ($item->form_inputs && is_array($item->form_inputs)) {
                                foreach ($item->form_inputs as $input) {
                                    $options = '';
                                    if ($input['type'] === 'select' || $input['type'] === 'radio') {
                                        $options = '|' . implode(',', $input['options']);
                                    }
                                    $inputs .= $input['label'] . '|' . $input['type'] . $options . "\n";
                                }
                            }
                          ?>
                          <label for="form_inputs" class="form-label">Yêu cầu đầu vào</label>
                          <textarea name="form_inputs" id="form_inputs" class="form-control" rows="4"><?php echo e($inputs); ?></textarea>
                          <ul class="mt-2">
                            <li>Input type: label|:type => Tài khoản|text, Mật khẩu|password</li>
                            <li>Input select: label|select|option1,option2,option3</li>
                            <li>Input radio: label|radio|option1,option2,option3</li>
                          </ul>
                        </div>
                        <div class="mb-3">
                          <?php
                            $packages = '';
                            if ($item->form_packages && is_array($item->form_packages)) {
                                foreach ($item->form_packages as $key => $package) {
                                    $packages .= $key . "\n";
                                }
                            }
                          ?>
                          <label for="form_packages" class="form-label">Danh sách gói rút</label>
                          <textarea name="form_packages" id="form_packages" class="form-control" rows="4"><?php echo e($packages); ?></textarea>
                        </div>
                        <div class="mb-3">
                          <label for="is_active" class="form-label">Trạng thái</label>
                          <select class="form-control" id="is_active" name="is_active">
                            <option value="1" <?php if($item->is_active === 1): ?> selected <?php endif; ?>>Hoạt
                              động
                            </option>
                            <option value="0" <?php if($item->is_active === 0): ?> selected <?php endif; ?>>Không
                              hoạt động
                            </option>
                          </select>
                        </div>
                        <div class="mb-3">
                          <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-create">Thêm mới
      </button>
    </div>
  </div>

  <div class="modal fade" id="modal-create" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Thêm thông tin mới</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('admin.inventories.vars.store')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
              <label for="image" class="form-label">Ảnh / Icon</label>
              <input class="form-control" type="file" id="image" name="image" required>
            </div>
            <div class="mb-3">
              <label for="name" class="form-label">Ghi chú</label>
              <input class="form-control" type="text" id="name" name="name">
            </div>
            <div class="mb-3">
              <label for="unit" class="form-label">Đơn vị</label>
              <input class="form-control" type="text" id="unit" name="unit" required>
            </div>
            <div class="mb-3 row">
              <div class="col-md-6">
                <label for="min_withdraw" class="form-label">Rút ít nhất</label>
                <input class="form-control" type="number" id="min_withdraw" name="min_withdraw" required>
              </div>
              <div class="col-md-6">
                <label for="max_withdraw" class="form-label">Rút nhiều nhất</label>
                <input class="form-control" type="number" id="max_withdraw" name="max_withdraw" required>
              </div>
            </div>
            <div class="mb-3">
              <label for="form_inputs" class="form-label">Yêu cầu đầu vào</label>
              <textarea name="form_inputs" id="form_inputs" class="form-control" rows="4"></textarea>
              <ul class="mt-2">
                <li>Input type: label|:type => Tài khoản|text, Mật khẩu|password</li>
                <li>Input select: label|select|option1,option2,option3</li>
                <li>Input radio: label|radio|option1,option2,option3</li>
              </ul>
            </div>
            <div class="mb-3">
              <label for="form_packages" class="form-label">Danh sách gói rút</label>
              <textarea name="form_packages" id="form_packages" class="form-control" rows="4" placeholder="Mỗi gói là 1 dòng... (10, 20, 30)"></textarea>
            </div>
            <div class="mb-3">
              <label for="is_active" class="form-label">Trạng thái</label>
              <select class="form-control" id="is_active" name="is_active">
                <option value="1">Hoạt động</option>
                <option value="0">Không hoạt động</option>
              </select>
            </div>
            <div class="mb-3">
              <button class="btn btn-primary w-100" type="submit">Thêm mới</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.inventories.vars.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/inventory/var/index.blade.php ENDPATH**/ ?>