<?php $__env->startSection('title', 'Admin: Boosting Package Edit #' . $package->id); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Cập nhật sản phẩm vào nhóm</div>
    </div>
    <div class="card-body">
      <form action="<?php echo e(route('admin.boosting.packages.update', ['id' => $package->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
        <?php echo csrf_field(); ?>
        <div class="row mb-3">
          <div class="col-md-6">
            <label for="name" class="form-label">Tên sản phẩm</label>
            <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name', $package->name)); ?>" placeholder="Tên sản phẩm cần bán" required>
          </div>
          <div class="col-md-6">
            <label for="price" class="form-label">Giá sản phẩm</label>
            <input type="text" class="form-control" id="price" name="price" value="<?php echo e(old('price', $package->price)); ?>" required>
          </div>
        </div>
        <div class="mb-3">
          <label for="status" class="form-label">Trạng thái</label>
          <select class="form-control" id="status" name="status" required>
            <option value="1" <?php if($package->status === true): ?> selected <?php endif; ?>>Đang bán</option>
            <option value="0" <?php if($package->status === false): ?> selected <?php endif; ?>>Chưa bán</option>
          </select>
        </div>
        <div class="mb-3">
          <label for="descr" class="form-label">Mô tả sản phẩm</label>
          <textarea class="form-control ckeditor" id="descr" name="descr" rows="3" required><?php echo e(old('descr', $package->descr)); ?></textarea>
        </div>
        <div class="mb-3 text-center">
          <button class="btn btn-primary">Sửa sản phẩm</button>
        </div>
      </form>
    </div>
  </div>
  <script src="/plugins/ckeditor/ckeditor.js"></script>

  <script>
  $(function() {
      const editors = document.querySelectorAll('.ckeditor');

      for (const editor of editors) {
          CKEDITOR.replace(editor, {
              extraPlugins: 'notification',
              clipboard_handleImages: false,
              filebrowserImageUploadUrl: '/api/admin/tools/upload?form=ckeditor'
          });
      }
  });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Documents/Workspace/known/resources/views/admin/boosting/packages/show.blade.php ENDPATH**/ ?>