<?php $__env->startSection('title', 'Admin: Withdraws Management'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý yêu cầu rút tiền cộng tác viên</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <td>#</td>
              <th>-</th>
              <td>Số tiền</td>
              <td>Ngân hàng</td>
              <td>Số tài khoản</td>
              <td>Trạng thái</td>
              <td>Thời gian</td>
              <td>Ghi chú</td>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($value->id); ?></td>
                <td class="text-center">
                  <a href="javscript:void(0)" class="text-danger" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($value->id); ?>">Chi Tiết</a>
                </td>
                <td><?php echo e(Helper::formatCurrency($value->amount)); ?></td>
                <td><?php echo e($value->payment_info['bank_name'] ?? ''); ?></td>
                <td><?php echo e($value->payment_info['account_name'] ?? ''); ?></td>
                <td><?php echo Helper::formatStatus($value->status); ?></td>
                <td><?php echo e($value->created_at); ?></td>
                <td><?php echo e($value->user_note); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <?php $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
      $payment = $value->payment_info;
    ?>
    <div class="modal fade" id="modal-edit-<?php echo e($value->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Cập nhật thông tin #<?php echo e($value->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="<?php echo e(route('admin.staff.withdraws.update')); ?>" method="POST" class="default-form">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="id" value="<?php echo e($value->id); ?>">

              <div class="row mb-3">
                <div class="col-md-6">
                  <label for="bank_name" class="form-label">Ngân hàng</label>
                  <input type="text" class="form-control" id="bank_name" name="bank_name" value="<?php echo e($payment['bank_name'] ?? '-'); ?>" disabled>
                </div>
                <div class="col-md-6">
                  <label for="account_number" class="form-label">Số tài khoản</label>
                  <input type="text" class="form-control" id="account_number" name="account_number" value="<?php echo e($payment['account_number'] ?? '-'); ?>" disabled>
                </div>
              </div>
              <div class="row mb-3">
                <div class="col-md-6">
                  <label for="account_name" class="form-label">Chủ tài khoản</label>
                  <input type="text" class="form-control" id="account_name" name="account_name" value="<?php echo e($payment['account_name'] ?? '-'); ?>" disabled>
                </div>
                <div class="col-md-6">
                  <label for="amount" class="form-label">Số tiền cần rút</label>
                  <input type="text" class="form-control" id="amount" name="amount" value="<?php echo e(Helper::formatCurrency($value->amount)); ?>" disabled>
                </div>
              </div>
              <div class="row mb-3">
                <div class="col-md-6">
                  <label for="user_note" class="form-label">Ghi Chú</label>
                  <textarea class="form-control" id="user_note" name="user_note" rows="3"><?php echo e($value->user_note); ?></textarea>
                </div>
                <div class="col-md-6">
                  <label for="sys_note" class="form-label">Ghi Chú Hệ Thống</label>
                  <textarea class="form-control" id="sys_note" name="sys_note" rows="3" disabled><?php echo e($value->sys_note); ?></textarea>
                </div>
              </div>
              <div class="mb-3">
                <label for="status" class="form-label">Trạng Thái</label>
                <select class="form-control" id="status" name="status">
                  <option value="Pending" <?php if($value->status === 'Pending'): ?> selected <?php endif; ?>>Đang Chờ</option>
                  <option value="Completed" <?php if($value->status === 'Completed'): ?> selected <?php endif; ?>>Hoàn Thành</option>
                  <option value="Cancelled" <?php if($value->status === 'Cancelled'): ?> selected <?php endif; ?>>Hủy Bỏ</option>
                </select>
              </div>
              <div class="text-center mb-3">
                <?php if($payment): ?>
                  <img
                    src="https://api.vietqr.io/<?php echo e($payment['bank_name']); ?>/<?php echo e($payment['account_number']); ?>/<?php echo e($value->amount); ?>/tt hoa don <?php echo e($value->order_id); ?>/vietqr_net_2.jpg?accountName=<?php echo e($payment['account_name']); ?>"
                    width="300" alt="">
                <?php endif; ?>
              </div>
              <div class="mb-3">
                <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

  <script>
    const setStatus = async (id, type) => {
      let simpleText = type === 'paid' ? 'đã thanh toán' : 'đã hủy'

      const confirm = await Swal.fire({
        title: 'Bạn có chắc chắn?',
        text: `Chuyển trạng thái hoá đơn này sang ${simpleText}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Đồng ý',
        cancelButtonText: 'Hủy',
      })

      if (confirm.isConfirmed !== true)
        return

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.invoices.update')); ?>', {
          id,
          type
        })

        Swal.fire("Thành công!", result.message, "success").then(() => {
          window.location.reload()
        })

      } catch (error) {
        Swal.fire("Thất bại", $catchMessage(error), "error")
      }

    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/staff/withdraws.blade.php ENDPATH**/ ?>