<?php $__env->startSection('title', 'Admin: Items Group'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý nhóm của chuyên mục "<?php echo e($category->name); ?>"</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Ưu tiên</th>
              <th>Thao tác</th>
              <th>Ảnh / Icon</th>
              <th>Tên nhóm</th>
              <th>Sản phẩm</th>
              <th>Trạng thái</th>
              <th>Người tạo</th>
              <th>Thời gian</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $category->groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td><?php echo e($item->priority); ?></td>
                <td>
                  <a href="javascript:void(0)" class="shadow btn btn-primary btn-xs sharp me-1" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>"><i class="fa fa-edit"></i> sửa</a>
                  <a href="<?php echo e(route('admin.boosting.packages', ['id' => $item->id])); ?>" class="shadow btn btn-info btn-xs sharp me-1"><i class="fa fa-eye"></i> Xem</a>
                  <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="shadow btn btn-danger btn-xs sharp me-1"><i class="fa fa-trash"></i> Xoá</a>
                </td>
                <td><img src="<?php echo e($item->image); ?>" width="40"></td>
                <td><?php echo e($item->name); ?></td>
                <td><?php echo e($item->packages()->count()); ?></td>
                <td>
                  <?php if($item->status == 1): ?>
                    <span class="text-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="text-danger">Tạm đóng</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>

              <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLabel">Cập nhật nhóm #<?php echo e($item->id); ?></h5>
                      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <form action="<?php echo e(route('admin.boosting.groups.update', ['id' => $item->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                          <label for="priority" class="form-label">Ưu tiên</label>
                          <input type="number" id="priority" name="priority" class="form-control" value="<?php echo e($item->priority); ?>" required>
                        </div>
                        <div class="mb-3">
                          <label for="image" class="form-label">Ảnh bìa</label>
                          <input type="file" id="image" name="image" class="form-control">
                        </div>
                        <div class="mb-3">
                          <label for="name" class="form-label">Tên nhóm</label>
                          <input type="text" class="form-control" id="name" name="name" placeholder="Nhập tên nhóm" value="<?php echo e($item->name); ?>" required>
                        </div>
                        <div class="mb-3">
                          <label for="descr" class="form-label">Mô tả</label>
                          <textarea class="form-control" id="descr" name="descr" rows="3" placeholder="Nhập ghi chú"><?php echo e($item->descr); ?></textarea>
                        </div>
                        <div class="mb-3">
                          <label for="status" class="form-label">Trạng thái</label>
                          <select class="form-control" id="status" name="status" required>
                            <option value="1" <?php if($item->status == 1): ?> selected <?php endif; ?>>Hoạt động</option>
                            <option value="0" <?php if($item->status == 0): ?> selected <?php endif; ?>>Tạm đóng</option>
                          </select>
                        </div>
                        <div class="mb-3">
                          <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-create"><i class="fa fa-edit"></i> Thêm nhóm mới</button>
      <a href="<?php echo e(route('admin.boosting.categories')); ?>" class="btn btn-danger"><i class="fa fa-arrow-left"></i> Quay lại danh sách chuyên mục</a>
    </div>
  </div>

  <div class="modal fade" id="modal-create" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Thêm thông tin mới</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('admin.boosting.groups.store', ['id' => $category->id])); ?>" method="POST" enctype="multipart/form-data" class="default-form">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
              <label for="category" class="form-label">Chuyên mục</label>
              <input type="text" id="category" class="form-control" value="<?php echo e($category->name); ?>" readonly>
            </div>
            <div class="mb-3">
              <label for="priority" class="form-label">Ưu tiên</label>
              <input type="number" id="priority" name="priority" class="form-control" value="0" required>
              <i>Số ưu tiên lớn thì nó hiện ở đầu</i>
            </div>
            <div class="mb-3">
              <label for="image" class="form-label">Ảnh bìa</label>
              <input type="file" id="image" name="image" class="form-control" required>
            </div>
            <div class="mb-3">
              <label for="name" class="form-label">Tên nhóm</label>
              <input type="text" class="form-control" id="name" name="name" placeholder="Nhập tên nhóm" required>
            </div>
            <div class="mb-3">
              <label for="descr" class="form-label">Mô tả</label>
              <textarea class="form-control" id="descr" name="descr" rows="3" placeholder="Nhập ghi chú"></textarea>
            </div>
            <div class="mb-3">
              <label for="status" class="form-label">Trạng thái</label>
              <select class="form-control" id="status" name="status" required>
                <option value="1">Hoạt động</option>
                <option value="0">Tạm đóng</option>
              </select>
            </div>
            <div class="mb-3">
              <button class="btn btn-primary w-100" type="submit">Thêm mới</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.boosting.groups.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Documents/Workspace/known/resources/views/admin/boosting/groups/index.blade.php ENDPATH**/ ?>