<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['categories', 'type' => 'account', 'bconfig' => null]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['categories', 'type' => 'account', 'bconfig' => null]); ?>
<?php foreach (array_filter((['categories', 'type' => 'account', 'bconfig' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>
<?php if($bconfig && isset($bconfig['product_cover'])): ?>
  <style>
    .border-image-card {
      border-width: 5px;
      /* Adjust the border width as needed */
      border-style: solid;
      /* Ensure the border style is set */
      border-image-source: url("<?php echo e($bconfig['product_cover']); ?>");
      /* URL of the image used for the border */
      border-image-slice: 30;
      /* Adjust this value based on how the image should be sliced */
      border-image-repeat: stretch;
      /* Options: stretch, repeat, round */
      border-image-outset: 0;
      /* Optional: Adjusts how far the border extends beyond the element */
    }
  </style>
<?php endif; ?>
<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="space-y-6 mb-10">
    <div class="text-center">
      <h1 class="text-xl md:text-4xl mb-1 text-primary"> <span class="category-name"><?php echo e($category->name); ?></span> </h1>
      <div class="h-1 bg-primary w-40 mx-auto"></div>
    </div>
    <div class="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-3">
      <?php if($type === 'account'): ?>
        <?php $__currentLoopData = \App\Models\SpinQuest::whereNotNull('category_id')->where('category_id', $category->id)->where('status', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spinQuest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="rounded-lg bg-white dark:bg-black-500 border border-primary hover:shadow-sm hover:shadow-primary-400 border-image-card">
            <div class="card-body">
              <a href="<?php echo e(route('games.spin-quest', ['id' => $spinQuest->id])); ?>" class="block">
                <img src="<?php echo e(asset('/images/svg/spinner.svg')); ?>" data-src="<?php echo e($spinQuest->cover); ?>" class="lazyload w-full h-28 md:h-44 lg:h-48 rounded-t-lg object-fit" alt="<?php echo e($spinQuest->name); ?>" />
              </a>
              <div class="pt-3 pb-3 cursor-pointer">
                <div class="text-center">
                  <h2 class="text-sm md:text-lg font-bold text-truncate hover:whitespace-normal mb-2">
                    <?php echo e($spinQuest->name); ?>

                  </h2>
                </div>
                <h4 class="text-xs md:text-sm lg:text-base font-bold text-center lg:flex lg:justify-around mb-2">
                  <div>
                    <i class="fas fa-credit-card me-1"></i><?php echo e(__t('Giá')); ?> : <span class="text-green-500"><?php echo e(Helper::formatCurrency($spinQuest->price)); ?></span>
                  </div>
                  <div>
                    <i class="fas fa-play me-1"></i> <?php echo e(__t('Đã chơi')); ?> : <span class="text-red-500"><?php echo e(number_format($spinQuest->play_times)); ?></span> lần
                  </div>
                </h4>
                <div class="flex justify-center">
                  <a href="<?php echo e(route('games.spin-quest', ['id' => $spinQuest->id])); ?>" class="btn btn-sm btn-primary"> <i class="fas fa-gift"></i> Chơi Ngay <i class="fas fa-gift"></i></a>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
      <?php $__currentLoopData = $category->groups()->where('status', true)->orderBy('priority', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $redirectUrl = '/tai-khoan/' . $group->slug;

          if ($type === 'item') {
              $redirectUrl = '/vat-pham/' . $group->slug;
          } elseif ($type === 'boosting') {
              $redirectUrl = '/cay-thue/' . $group->slug;
          } elseif ($type === 'account_v2') {
              $redirectUrl = '/tai-khoan-v2/' . $group->slug;
          }
        ?>
        <div class="rounded-lg bg-white dark:bg-black-500 border border-primary hover:shadow-sm hover:shadow-primary-400 border-image-card">
          <div class="card-body">
            <a href="<?php echo e($redirectUrl); ?>" class="block">
              <img src="<?php echo e(asset('/images/svg/spinner.svg')); ?>" data-src="<?php echo e($group->image); ?>" class="lazyload w-full h-28 md:h-44 lg:h-48 rounded-t-lg object-fit border border-gray-300" alt="<?php echo e($group->name); ?>" />
            </a>
            <div class="pt-3 pb-3 cursor-pointer">
              <div class="flex flex-col items-center">
                <div class="text-center w-full">
                  <h2 class="text-sm md:text-lg font-bold text-truncate hover:whitespace-normal mb-2"><?php echo e($group->name); ?></h2>
                  <?php if($type === 'account'): ?>
                    <?php if($group->in_stock > 0): ?>
                      <h4 class="text-xs md:text-sm lg:text-base font-bold">
                        <?php if($bconfig['product_info_type'] ?? false): ?>
                          <?php echo e(__t('Đã Bán')); ?> <span class="text-primary-500"><?php echo e($group->sold_count); ?></span> <span class="hidden md:inline-block"><?php echo e(__t('Nick')); ?></span>
                          <span>|</span>
                        <?php endif; ?>
                        <?php echo e(__t('Còn')); ?> <span class="text-red-500"><?php echo e($group->in_stock); ?></span> <span class="hidden md:inline-block"><?php echo e(__t('Nick')); ?></span>
                      </h4>
                    <?php elseif($group->total_item !== 0): ?>
                      <h4 class="text-xs md:text-sm lg:text-base font-bold"><?php echo e(__t('Bán Hết')); ?> <span class="text-red-500"><?php echo e($group->sold_count); ?></span> Nick</h4>
                    <?php else: ?>
                      <h4 class="text-xs md:text-sm lg:text-base font-bold"><?php echo e(__t('Trạng Thái')); ?>: <span class="text-danger-500"><?php echo e(__t('Hết Hàng')); ?></span></h4>
                    <?php endif; ?>
                  <?php elseif($type === 'account_v2'): ?>
                    <h4 class="text-xs md:text-sm lg:text-base font-bold">
                      <?php if($bconfig['product_info_type'] ?? false): ?>
                        <?php echo e(__t('Đã Bán')); ?> <span class="text-primary-500"><?php echo e($group->sold); ?></span> <span class="hidden md:inline-block"><?php echo e(__t('Nick')); ?></span>
                        <span>|</span>
                      <?php endif; ?>
                      <?php echo e(__t('Còn')); ?> <span class="text-red-500"><?php echo e($group->in_stock); ?></span> <span class="hidden md:inline-block"><?php echo e(__t('Nick')); ?></span>
                    </h4>
                    
                  <?php else: ?>
                    <h4 class="text-xs md:text-sm lg:text-base font-bold"><?php echo e(__t('Trạng Thái')); ?>: <span class="text-green-500"><?php echo e(__t('Sẵn Sàng')); ?></span></h4>
                  <?php endif; ?>
                </div>
                <div class="flex justify-center mt-2">
                  <a href="<?php echo e($redirectUrl); ?>">
                    <img src="<?php echo e($bconfig['buy_button_img'] ?? asset('_assets/images/stores/view-all.gif')); ?>" class="w-full max-h-12" alt="<?php echo e(__t('Xem Tất Cả')); ?>">
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /Users/admin/Downloads/don1/resources/views/components/category-list.blade.php ENDPATH**/ ?>