<?php $__env->startSection('title', 'Admin: Accounts Group'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý nhóm của chuyên mục "<?php echo e($category->name); ?>"</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Ưu tiên</th>
              <th>Thao tác</th>
              <th>Ảnh / Icon</th>
              <th>Tên nhóm</th>
              <th>Đã bán</th>
              <th>Còn lại</th>
              <th>Doanh thu</th>
              <th>Trạng thái</th>
              <th>Người tạo</th>
              <th>Thời gian</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $category->groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td><?php echo e($item->priority); ?></td>
                <td>
                  <a href="<?php echo e(route('admin.accounts.groups.edit', ['id' => $category->id, 'gid' => $item->id])); ?>" class="badge bg-primary-gradient text-white me-1"><i class="fa fa-edit"></i> sửa</a>
                  <a href="<?php echo e(route('admin.accounts.items', ['id' => $item->id])); ?>" class="badge bg-info-gradient text-white me-1"><i class="fa fa-eye"></i> Xem</a>
                  <a href="javascript:deleteRow(<?php echo e($item->id); ?>)" class="badge bg-danger-gradient text-white me-1"><i class="fa fa-trash"></i> Xoá</a>
                </td>
                <td><img src="<?php echo e($item->image); ?>" width="40"></td>
                <td><?php echo e($item->name); ?></td>
                <td><span class="text-primary"><?php echo e($item->sold_count); ?></span> nick</td>
                <td><span class="text-danger"><?php echo e($item->in_stock); ?></span> nick</td>
                <td><?php echo e(Helper::formatCurrency($item->revenue)); ?></td>
                <td>
                  <?php if($item->status == 1): ?>
                    <span class="text-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="text-danger">Tạm đóng</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <a href="<?php echo e(route('admin.accounts.groups.create', ['id' => $category->id])); ?>" class="btn btn-primary"><i class="fa fa-edit"></i> Thêm nhóm mới</a>
      <a href="<?php echo e(route('admin.accounts.categories')); ?>" class="btn btn-danger"><i class="fa fa-arrow-left"></i> Quay lại danh sách chuyên mục</a>
    </div>
  </div>

  <div class="modal fade" id="modal-create" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog  modal-xl" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Thêm thông tin mới</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">

        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.accounts.groups.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/accounts/groups/index.blade.php ENDPATH**/ ?>