<?php $__env->startSection('title', $pageTitle); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Danh sách yêu cầu rút thưởng [MỚI]</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped text-nowrap datatable">
          <thead>
            <tr>
              <th>#</th>
              <th data-orderable="false" style="width: 30px">Thao tác</th>
              <th>Mã đơn</th>
              <th>Số lượng</th>
              <th>Trò chơi</th>
              <th>Dữ liệu</th>
              <th>Trạng thái</th>
              <th>Người tạo</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td class="text-center">
                  <a href="javascript:void(0)" class="badge bg-danger-gradient" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">Sửa</a>
                </td>
                <td><?php echo e($item->code); ?></td>
                <td><?php echo e($item->amount); ?> <?php echo e($item->unit); ?></td>
                <td><?php echo e($item->name); ?></td>
                <td>
                  <?php $__currentLoopData = $item->user_inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $input): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="me-2"><?php echo e($input['label']); ?>: <i class="copy cursor-pointer" data-clipboard-text="<?php echo e($input['value']); ?>"><?php echo e($input['value']); ?></i></span>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                  <?php if($item->status === 'Pending'): ?>
                    <span class="badge bg-warning">Đang chờ</span>
                  <?php elseif($item->status === 'Approved'): ?>
                    <span class="badge bg-success">Đã duyệt</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Từ chối</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->username); ?></td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>

              <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="exampleModalLabel">Cập nhật thông tin
                        #<?php echo e($item->id); ?></h5>
                      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <form action="<?php echo e(route('admin.inventory.withdraws.update', ['id' => $item->id])); ?>" method="POST" enctype="multipart/form-data" class="axios-form" data-reload="1">
                        <?php echo csrf_field(); ?>
                        <div class="row mb-3">
                          <div class="col-md-6">
                            <label for="amount" class="form-label">Số lượng</label>
                            <input class="form-control" type="text" id="amount" name="amount" value="<?php echo e(number_format($item->amount)); ?>" disabled>
                          </div>
                          <div class="col-md-6">
                            <label for="unit" class="form-label">Đơn vị</label>
                            <input class="form-control" type="text" id="unit" name="unit" value="<?php echo e($item->unit); ?>" disabled>
                          </div>
                        </div>
                        <div class="mb-3">
                          <label for="status" class="form-label">Trạng thái</label>
                          <select class="form-control" id="status" name="status">
                            <option value="Pending">Đang chờ</option>
                            <option value="Approved">Đã duyệt</option>
                            <option value="Rejected">Từ chối</option>
                          </select>
                        </div>

                        <div class="mb-3">
                          <label for="admin_note" class="form-label">Ghi chú</label>
                          <textarea name="admin_note" id="admin_note" class="form-control" rows="4"><?php echo e($item->admin_note); ?></textarea>
                        </div>
                        <div class="mb-3">
                          <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/inventory/withdraw/index.blade.php ENDPATH**/ ?>