<div class="leading-0 hidden w-full md:block">
  <button class="inline-flex items-center rounded-lg text-center text-sm font-medium text-slate-800 focus:outline-none focus:ring-0 dark:text-white" type="button" data-bs-toggle="dropdown" aria-expanded="false">
    <div class="h-7 w-7 flex-1 rounded-full ltr:mr-[10px] rtl:ml-[10px] lg:h-8 lg:w-8">
      <img class="block h-full w-full rounded-full object-cover" src="<?php echo e(Auth::user()->avatar ?? '/images/avatar/av-1.svg'); ?>" alt="user" />
    </div>
    <div class="ltr:text-left rtl:text-right">
      <span class="hidden flex-none items-center overflow-hidden text-ellipsis whitespace-nowrap text-sm font-bold text-slate-600 dark:text-white lg:flex">
        <?php echo e(Str::limit(Auth::user()?->username, 20) ?? __t('Khách')); ?>

      </span>
      <small class="text-danger-600 block text-[15px] font-bold"><?php echo e(Helper::formatCurrency(auth()->user()?->balance ?? 0)); ?></small>
    </div>
    <svg class="ml-[10px] inline-block h-[16px] w-[16px] text-base rtl:mr-[10px] dark:text-white lg:inline-block" aria-hidden="true" fill="none" stroke="currentColor" viewbox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg">
      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
    </svg>
  </button>
  <!-- Dropdown menu -->
  <div class="dropdown-menu !top-[23px] z-10 hidden w-44 divide-y divide-slate-100 overflow-hidden rounded-md border bg-white shadow dark:border-slate-700 dark:bg-slate-800">
    <ul class="py-1 text-sm text-slate-800 dark:text-slate-200" :class="listView ? 'z-20 opacity-100 top-[61px]' : 'opacity-0 -z-20 top-5'" x-show="listView" @click.away="listView = false">
      <?php if(Auth::check()): ?>
        <li>
          <a href="<?php echo e(route('account.deposits.index')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white"
            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'active' => request()->routeIs('account.deposits.index'),
            ]); ?>">
            <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="carbon:money"></iconify-icon>
            <span class="dropdown-option">
              <?php echo e(__t('Nạp Tiền')); ?>

            </span>
          </a>
        </li>
        <li>
          <a href="<?php echo e(route('account.profile.index')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white"
            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'country-list',
                'active' => request()->routeIs('profiles.index'),
            ]); ?>">
            <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="carbon:user-avatar">
            </iconify-icon>
            <span class="dropdown-option">
              <?php echo e(__t('Thông Tin')); ?>

            </span>
          </a>
        </li>
        <?php if(Auth::check() && in_array(Auth::user()->role, ['admin', 'partner', 'accounting'])): ?>
          <li>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white">
              <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="carbon:share">
              </iconify-icon>
              <span class="dropdown-option">
                <?php echo e(__t('Trang Quản Trị')); ?>

              </span>
            </a>
          </li>
        <?php endif; ?>
        <?php if(Auth::check() && Auth::user()->colla_type): ?>
          <li>
            <a href="<?php echo e(route('staff.dashboard')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white">
              <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="carbon:share">
              </iconify-icon>
              <span class="dropdown-option">
                <?php echo e(__t('Cộng Tác Viên')); ?>

              </span>
            </a>
          </li>
        <?php endif; ?>
        
        <li>
          <form method="POST" action="<?php echo e(route('logout')); ?>"
            class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white">
            <?php echo csrf_field(); ?>
            <button type="submit" class="country-list flex items-start">
              <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="carbon:logout">
              </iconify-icon>
              <span class="dropdown-option">
                <?php echo e(__t('Đăng Xuất')); ?>

              </span>
            </button>
          </form>
        </li>
      <?php else: ?>
        <li>
          <a href="<?php echo e(route('login')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white"
            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'active' => request()->routeIs('login'),
            ]); ?>">
            <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="material-symbols:login"></iconify-icon>
            <span class="dropdown-option">
              <?php echo e(__t('Đăng Nhập')); ?>

            </span>
          </a>
        </li>
        <li>
          <a href="<?php echo e(route('register')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white"
            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'active' => request()->routeIs('register'),
            ]); ?>">
            <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="solar:user-linear"></iconify-icon>
            <span class="dropdown-option">
              <?php echo e(__t('Tạo Tài Khoản')); ?>

            </span>
          </a>
        </li>
        <li>
          <a href="<?php echo e(route('password.request')); ?>" class="font-inter flex items-center px-4 py-2 text-sm font-normal text-slate-600 hover:bg-slate-100 dark:text-white dark:hover:bg-slate-600 dark:hover:text-white"
            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                'active' => request()->routeIs('password.request'),
            ]); ?>">
            <iconify-icon class="text-textColor mr-2 text-lg dark:text-white" icon="solar:password-linear"></iconify-icon>
            <span class="dropdown-option">
              <?php echo e(__t('Quên Mật Khẩu?')); ?>

            </span>
          </a>
        </li>
      <?php endif; ?>
    </ul>
  </div>
</div>
<?php /**PATH /Users/admin/Downloads/__MACOSX/resources/views/components/nav-user-dropdown.blade.php ENDPATH**/ ?>