
<?php $__env->startSection('title', 'CTV: Quản lý đơn cày ctv'); ?>

<?php $__env->startSection('content'); ?>
<div class="card custom-card">
    <div class="card-header justify-content-between">
        <div class="card-title">Đơn cày ctv của tôi</div>
    </div>

    <div class="card-body">
        <div class="table-responsive theme-scrollbar p-2">
            <table class="display table table-bordered table-striped text-center datatable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Mã đơn</th>
                        <th>Dịch vụ</th>
                        <th>Tài khoản</th>
                        <th>Thanh toán</th>
                        <th>Ghi chú khách</th>
                        <th>Ngày nhận</th>
                        <th>Ngày xong</th>
                        <th>Tiền nhận</th>
                        <th>Trạng thái</th>
                        <th>Cập nhật</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item->id); ?></td>
                        <td><?php echo e($item->code); ?></td>
                        <td><?php echo e($item->name); ?></td>
                        <td><?php echo e($item->username); ?></td>
                        <td><?php echo e(Helper::formatCurrency($item->payment)); ?></td>
                        <td><?php echo e($item->order_note); ?></td>
                        <td><?php echo e($item->assigned_at); ?></td>
                        <td><?php echo e($item->assigned_completed ?? '-'); ?></td>
                        <td><?php echo e($item->assigned_payment ? Helper::formatCurrency($item->assigned_payment) : '-'); ?></td>

                        <td>
                            <?php if($item->assigned_status === 'Completed'): ?>
                                <span class="badge bg-success">Hoàn thành</span>
                            <?php elseif($item->assigned_status === 'Processing'): ?>
                                <span class="badge bg-primary">Đang cày</span>
                            <?php else: ?>
                                <span class="badge bg-warning">Chưa làm</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <a href="javascript:void(0)" class="btn btn-info btn-xs" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">
                                <i class="fa fa-edit"></i> sửa
                            </a>
                        </td>
                    </tr>

                    
                    <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <h5 class="modal-title">Cập nhật đơn #<?php echo e($item->id); ?></h5>
                                    <button class="btn-close" data-bs-dismiss="modal"></button>
                                </div>

                                <form action="<?php echo e(route('ctv.orders.update', ['id' => $item->id])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label class="fw-bold">Ghi chú khách</label>
                                            <textarea class="form-control" rows="3" disabled><?php echo e($item->order_note); ?></textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label class="fw-bold">Ghi chú CTV</label>
                                            <textarea class="form-control" name="assigned_note" rows="3"><?php echo e($item->assigned_note); ?></textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label class="fw-bold">Trạng thái của bạn</label>
                                            <select class="form-select" name="assigned_status" required>
                                                <option value="Processing" <?php echo e($item->assigned_status === 'Processing' ? 'selected' : ''); ?>>Đang cày</option>
                                                <option value="Completed" <?php echo e($item->assigned_status === 'Completed' ? 'selected' : ''); ?>>Hoàn thành</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-primary">Cập nhật</button>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ctv.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Documents/Workspace/known/resources/views/admin/boosting/ctv/index.blade.php ENDPATH**/ ?>