<?php $__env->startSection('title', 'Đơn hàng của CTV: ' . $ctv->username); ?>

<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">
        Đơn hàng Cày Thuê của CTV: <?php echo e($ctv->username); ?> (ID: <?php echo e($ctv->id); ?>)
      </div>

      <a href="<?php echo e(route('admin.boosting.ctv.stats')); ?>" class="btn btn-secondary btn-sm">
        <i class="fa fa-arrow-left"></i> Quay lại thống kê CTV
      </a>
    </div>

    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center">
          <thead>
            <tr>
              <th>#</th>
              <th>Mã đơn</th>
              <th>Khách hàng</th>
              <th>Trạng thái</th>
              <th>Thanh toán</th>
              <th>Tiền CTV (assigned_payment)</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>

          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td><?php echo e($order->id); ?></td>
                <td>#<?php echo e($order->code); ?></td>
                <td><?php echo e($order->username ?? 'N/A'); ?> (ID: <?php echo e($order->user_id); ?>)</td>
                <td><?php echo e($order->status); ?></td>
                <td><?php echo e(number_format($order->payment ?? 0, 0, ',', '.')); ?> đ</td>
                <td><?php echo e(number_format($order->assigned_payment ?? 0, 0, ',', '.')); ?> đ</td>
                <td><?php echo e($order->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="7">CTV này chưa nhận đơn nào.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="mt-3">
        <?php echo e($orders->links()); ?>

      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Downloads/don1/resources/views/admin/boosting/ctv/orders.blade.php ENDPATH**/ ?>