<?php $__env->startSection('title', 'Admin: Pin Groups'); ?>
<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý danh sách được ghim</div>
    </div>
    <div class="card-body">
      <div class="table-responsive theme-scrollbar">
        <table class="display table table-bordered table-stripped datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Thao tác</th>
              <th>Tên / Ảnh</th>
              <th>Mở bằng</th>
              <th>Trạng thái</th>
              <th>Ngày tạo</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $pin_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>
                <td>
                  <button class="badge bg-primary" data-bs-toggle="modal" data-bs-target="#modal-edit-<?php echo e($item->id); ?>">Sửa</button>
                  <button class="badge bg-danger" onclick="deleteRow(<?php echo e($item->id); ?>)">Xóa</button>
                </td>
                <td>
                  <a href="<?php echo e($item->image); ?>" target="_blank"><?php echo e($item->name); ?></a>
                </td>
                <td><?php echo e($item->open_type); ?></td>
                <td>
                  <?php if($item->status === true): ?>
                    <span class="badge bg-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Không hoạt động</span>
                  <?php endif; ?>
                </td>
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
    <div class="card-footer">
      <button class="btn btn-primary-gradient" data-bs-toggle="modal" data-bs-target="#modal-create">Thêm thông tin</button>
    </div>
  </div>

  <div class="modal fade" id="modal-create" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Thêm thông tin</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('admin.pin-groups.store')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
              <label for="image" class="form-label">Ảnh / Icon</label>
              <input class="form-control" type="file" id="image" name="image" required>
            </div>
            <div class="mb-3">
              <label for="name" class="form-label">Tiêu đề</label>
              <input class="form-control" type="text" id="name" name="name" required>
            </div>
            <div class="mb-3">
              <label for="link" class="form-label">Liên kết</label>
              <input class="form-control" type="url" id="link" name="link" required>
            </div>
            <div class="mb-3">
              <label for="open_type" class="form-label">Mở bằng</label>
              <select class="form-control" id="open_type" name="open_type" required>
                <option value="_blank">Mở trong cửa sổ mới</option>
                <option value="_self">Mở trong cùng cửa sổ</option>
              </select>
            </div>
            <div class="mb-3">
              <label for="status" class="form-label">Trạng thái</label>
              <select class="form-control" id="status" name="status">
                <option value="1">Hoạt động</option>
                <option value="0">Không hoạt động</option>
              </select>
            </div>
            <div class="mb-3">
              <button class="btn btn-danger-gradient w-100" type="submit">Thêm mới</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php $__currentLoopData = $pin_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="modal-edit-<?php echo e($value->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Cập nhật thông tin #<?php echo e($value->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="<?php echo e(route('admin.pin-groups.update')); ?>" method="POST" enctype="multipart/form-data" class="default-form">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
              <div class="mb-3">
                <label for="image" class="form-label">Ảnh / Icon</label>
                <input class="form-control" type="file" id="image" name="image">
              </div>
              <div class="mb-3">
                <label for="name" class="form-label">Tiêu đề</label>
                <input class="form-control" type="text" id="name" name="name" value="<?php echo e($value->name); ?>" required>
              </div>
              <div class="mb-3">
                <label for="link" class="form-label">Liên kết</label>
                <input class="form-control" type="url" id="link" name="link" value="<?php echo e($value->link); ?>" required>
              </div>
              <div class="mb-3">
                <label for="open_type" class="form-label">Mở bằng</label>
                <select class="form-control" id="open_type" name="open_type" required>
                  <option value="_blank" <?php if($value->open_type === '_blank'): ?> selected <?php endif; ?>>Mở trong cửa sổ mới</option>
                  <option value="_self" <?php if($value->open_type === '_self'): ?> selected <?php endif; ?>>Mở trong cùng cửa sổ</option>
                </select>
              </div>
              <div class="mb-3">
                <label for="status" class="form-label">Trạng thái</label>
                <select class="form-control" id="status" name="status">
                  <option value="1" <?php if($value->status): ?> selected <?php endif; ?>>Hoạt động</option>
                  <option value="0" <?php if(!$value->status): ?> selected <?php endif; ?>>Không hoạt động</option>
                </select>
              </div>
              <div class="mb-3">
                <button class="btn btn-danger-gradient w-100" type="submit">Thêm mới</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Bạn sẽ không thể khôi phục lại dữ liệu này!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const {
          data: result
        } = await axios.post('<?php echo e(route('admin.pin-groups.delete')); ?>', {
          id
        })

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        })
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error')
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/arowne0zfj6/public_html/resources/views/admin/pins/index.blade.php ENDPATH**/ ?>