
<?php $__env->startSection('title', 'Admin: Quản lý Cộng Tác Viên'); ?>

<?php $__env->startSection('content'); ?>
  <div class="card custom-card">
    <div class="card-header justify-content-between">
      <div class="card-title">Quản lý Cộng Tác Viên</div>
    </div>

    <div class="card-body">
      <div class="table-responsive theme-scrollbar p-2">
        <table class="display table table-bordered table-stripped text-center datatable">
          <thead>
            <tr>
              <th>#</th>
              <th>Ưu tiên</th>
              <th>Thao tác</th>
              <th>Tên Cộng Tác Viên</th>
              <th>SĐT</th>
              <th>Ghi chú</th>
              <th>Trạng thái</th>
              <th>Thời gian</th>
            </tr>
          </thead>

          <tbody>
            <?php $__currentLoopData = $collaborators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($item->id); ?></td>

                
                <td><?php echo e($item->priority ?? 0); ?></td>

                
                <td>
                  <div class="d-flex justify-content-center gap-1">
                    <button type="button"
                            class="shadow btn btn-primary btn-xs sharp"
                            data-bs-toggle="modal"
                            data-bs-target="#modal-edit-<?php echo e($item->id); ?>">
                      <i class="fa fa-edit"></i> sửa
                    </button>

                    <button type="button"
                            class="shadow btn btn-danger btn-xs sharp"
                            onclick="deleteRow(<?php echo e($item->id); ?>)">
                      <i class="fa fa-trash"></i> xoá
                    </button>
                  </div>
                </td>

                
                <td><?php echo e($item->name); ?></td>

                
                <td><?php echo e($item->phone ?? '-'); ?></td>

                
                <td><?php echo e($item->note ?? '-'); ?></td>

                
                <td>
                  <?php if($item->active): ?>
                    <span class="badge bg-success">Hoạt động</span>
                  <?php else: ?>
                    <span class="badge bg-danger">Tạm đóng</span>
                  <?php endif; ?>
                </td>

                
                <td><?php echo e($item->created_at); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>

        </table>
      </div>
    </div>

    <div class="card-footer">
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal-create">
        <i class="fa fa-plus"></i> Thêm Cộng Tác Viên Mới
      </button>
    </div>
  </div>

  
  <?php $__currentLoopData = $collaborators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="modal-edit-<?php echo e($item->id); ?>" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Cập nhật Cộng Tác Viên #<?php echo e($item->id); ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body">
            <form action="<?php echo e(route('admin.boosting.ctv.update', $item->id)); ?>"
                  method="POST"
                  class="default-form">
              <?php echo csrf_field(); ?>

              <div class="mb-3">
                <label class="form-label">Tên Cộng Tác Viên</label>
                <input type="text" class="form-control" name="name" value="<?php echo e($item->name); ?>" required>
              </div>

              <div class="mb-3">
                <label class="form-label">Số điện thoại</label>
                <input type="text" class="form-control" name="phone" value="<?php echo e($item->phone); ?>">
              </div>

              <div class="mb-3">
                <label class="form-label">Ưu tiên</label>
                <input type="number" class="form-control" name="priority" value="<?php echo e($item->priority ?? 0); ?>">
              </div>

              <div class="mb-3">
                <label class="form-label">Ghi chú</label>
                <textarea class="form-control" name="note" rows="3"><?php echo e($item->note); ?></textarea>
              </div>

              <div class="mb-3">
                <label class="form-label">Trạng thái</label>
                <select class="form-select" name="active">
                  <option value="1" <?php echo e($item->active ? 'selected' : ''); ?>>Hoạt động</option>
                  <option value="0" <?php echo e(!$item->active ? 'selected' : ''); ?>>Tạm đóng</option>
                </select>
              </div>

              <button class="btn btn-primary w-100" type="submit">Cập nhật</button>
            </form>
          </div>

        </div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

  
  <div class="modal fade" id="modal-create" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">

        <div class="modal-header">
          <h5 class="modal-title">Thêm Cộng Tác Viên</h5>
          <button class="btn-close" type="button" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <form action="<?php echo e(route('admin.boosting.ctv.store')); ?>"
                method="POST"
                class="default-form">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
              <label class="form-label">Tên Cộng Tác Viên</label>
              <input type="text" class="form-control" name="name" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Số điện thoại</label>
              <input type="text" class="form-control" name="phone">
            </div>

            <div class="mb-3">
              <label class="form-label">Ưu tiên</label>
              <input type="number" class="form-control" name="priority" value="0">
            </div>

            <div class="mb-3">
              <label class="form-label">Ghi chú</label>
              <textarea class="form-control" name="note" rows="3"></textarea>
            </div>

            <div class="mb-3">
              <label class="form-label">Trạng thái</label>
              <select class="form-select" name="active">
                <option value="1">Hoạt động</option>
                <option value="0">Tạm đóng</option>
              </select>
            </div>

            <button class="btn btn-primary w-100" type="submit">Thêm mới</button>
          </form>
        </div>

      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
  <script>
    const deleteRow = async (id) => {
      const confirmDelete = await Swal.fire({
        title: 'Bạn có chắc chắn muốn xóa?',
        text: "Hành động này không thể hoàn tác!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy'
      });

      if (!confirmDelete.isConfirmed) return;

      $showLoading();

      try {
        const { data: result } = await axios.post(
          '<?php echo e(route('admin.boosting.ctv.delete')); ?>',
          { id }
        );

        Swal.fire('Thành công', result.message, 'success').then(() => {
          window.location.reload();
        });
      } catch (error) {
        Swal.fire('Thất bại', $catchMessage(error), 'error');
      }
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/admin/Downloads/don1/resources/views/admin/boosting/ctv/index.blade.php ENDPATH**/ ?>