<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('g_b_orders', function (Blueprint $table) {
            $table->unsignedBigInteger('collaborator_id')->nullable()->after('user_id');

            $table->foreign('collaborator_id')
                ->references('id')
                ->on('gb_collaborators')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('g_b_orders', function (Blueprint $table) {
            $table->dropForeign(['collaborator_id']);
            $table->dropColumn('collaborator_id');
        });
    }
};
