<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('inventory_vars', function (Blueprint $table) {
      $table->id();
      $table->string('name');
      $table->string('unit');
      $table->string('image')->nullable();
      $table->boolean('is_active')->default(1);
      $table->json('form_inputs')->nullable();
      $table->json('form_packages')->nullable();
      $table->integer('min_withdraw')->default(0);
      $table->integer('max_withdraw')->default(1000);
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('inventory_vars');
  }
};
