<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GBCollaborator extends Model
{
    use HasFactory;

    protected $table = 'gb_collaborators';

    protected $fillable = [
        'name',
        'phone',
        'priority',
        'active',
        'note',
    ];

    public function orders()
    {
        return $this->hasMany(GBOrder::class, 'collaborator_id');
    }
}
