<?php

namespace App\Http\Controllers\Admin\Boosting;

use App\Http\Controllers\Controller;
use App\Models\GBOrder;
use App\Models\Category; // HOẶC model đúng của bạn
use App\Models\User;
use Helper;
use Illuminate\Http\Request;

class CtvController extends Controller
{
    public function stats()
    {
        $ctvs = User::where('colla_type', 'boosting')
            ->orderBy('username')
            ->get();

        $rawStats = GBOrder::selectRaw('
                assigned_to,
                COUNT(*) as total_orders,
                SUM(CASE WHEN status = "Completed" THEN 1 ELSE 0 END) as completed_orders,
                SUM(assigned_payment) as total_revenue
            ')
            ->whereNotNull('assigned_to')
            ->groupBy('assigned_to')
            ->get()
            ->keyBy('assigned_to');

        return view('admin.boosting.ctv.stats', [
            'ctvs'      => $ctvs,
            'statsByCt' => $rawStats,
        ]);
    }

    public function orders(string $username)
    {
        $ctv = User::where('username', $username)
            ->where('colla_type', 'boosting')
            ->firstOrFail();

        $orders = GBOrder::where('assigned_to', $ctv->username)
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        return view('admin.boosting.ctv.orders', compact('ctv', 'orders'));
    }
}
